## 深入資訊
`GeometryColor.ByMeshColor` 會傳回 GeometryColor 物件，此物件是按照給定顏色清單上色的網格。有幾種方法可以使用此節點:

- 如果提供一種顏色，則會使用一種給定的顏色為整個網格上色;
- 如果顏色數與三角形數相符，則會使用清單中的對應顏色為每個三角形上色;
- 如果顏色數與唯一頂點數相符，則網格顏色中每個三角形的顏色會在每個頂點處的顏色值之間進行內插;
- 如果顏色數等於非唯一頂點數，則每個三角形的顏色會在一個面的顏色值之間進行內插，但不會在不同面之間進行混成。

## 範例

在以下範例中，會根據網格頂點的高程為網格顯示不同顏色。首先，使用 `Mesh.Vertices` 取得唯一的網格頂點，然後進行分析，使用 `Point.Z` 節點取得每個頂點的高程。其次，使用 `Map.RemapRange` 按比例調整每個值，將值對映到新的 0 到 1 範圍。最後，使用 `Color Range` 產生與對映值對應的顏色清單。使用此顏色清單作為 `GeometryColor.ByMeshColors` 節點的 `colors` 輸入。結果是一個顯示不同顏色的網格，其中每個三角形的顏色在頂點顏色之間會進行內插而產生漸層顏色。

## 範例檔案

![Example](./Modifiers.GeometryColor.ByMeshColors_img.jpg)
