## 深入資訊

Bar Chart 會使用垂直方向的長條建立一個圖。長條可以分成多個群組，並用顏色標示。您可以選擇輸入一個倍精度值建立一個群組，或在 values 輸入的每個子清單輸入多個倍精度值建立多個群組。若要定義品類，請在 labels 輸入中插入字串值清單。每個值都會建立一個顯示不同顏色的新品類。

若要對每個長條指定值 (高度)，請在 values 輸入中輸入一個包含倍精度值之清單的清單。每個子清單將以與 labels 輸入相同的順序決定長條數及所屬的品類。如果您只有一個倍精度值清單，則只會建立一個品類。labels 輸入中的字串值數必須符合 values 輸入中的子清單數。

若要為每個品類指定顏色，請在 colors 輸入中插入顏色清單。指定自訂顏色時，顏色數必須符合 labels 輸入中的字串值數。如果未指定任何顏色，則會使用隨機顏色。

## 範例: 單一群組

想像您要為某個項目表示一年前三個月的平均使用者評分。若要顯示此案例，您需要一個包含三個字串值的清單，分別標示為「一月」、「二月」和「三月」。
因此，對於 labels 輸入，我們將在 Code Block 中提供以下清單:

["一月", "二月", "三月"];

您也可以使用字串節點連接到 List Create 節點來建立清單。

接下來，在 values 輸入中，我們將為三個月的每個月輸入平均使用者評分做為清單的清單:

[[3.5], [5], [4]];

請注意，由於我們有三個標示，因此需要三個子清單。

現在，當圖表執行時，將建立長條圖，每個有顏色的長條表示該月份的平均客戶評分。您可以繼續使用預設顏色，或在 colors 輸入中插入自訂顏色清單。

## 範例: 多個群組

您可以透過在 values 輸入的每個子清單中輸入更多值，來利用 Bar Chart 節點的分組功能。在此範例中，我們來建立一個圖表，以模型 A、模型 B 和模型 C 三個模型的變化來顯示門的數目。

為了執行此作業，我們先提供以下標示:

["模型 A", "模型B", "模型C"];

接下來，我們將提供值，同樣要確保子清單數符合標示數:

[[17, 9, 13],[12,11,15],[15,8,17]];

現在，當您按一下「執行」時，Bar Chart 節點將建立一個包含三組長條的圖表，分別標示為索引 0、1 和 2。在此範例中，將每個索引 (即群組) 想成是一個設計變化。第一組 (索引 0) 中的值是從 values 輸入中每個清單的第一個項目提取，因此第一組的模型 A 包含 17，模型 B 為 12，模型 C 為 15。第二組 (索引 1) 使用每一組中的第二個值，依此類推。

___
## 範例檔案

![Bar Chart](./CoreNodeModelsWpf.Charts.BarChartNodeModel_img.jpg)

