## 详细
“GeometryColor.ByMeshColor”返回 GeometryColor 对象，该对象是按照给定颜色列表着色的网格。此节点的使用方法有多种:

- 如果提供一种颜色，则整个网格将用一种给定的颜色着色；
- 如果颜色数量与三角形数量匹配，则每个三角形都按列表中的相应颜色着色；
- 如果颜色数量与唯一顶点数量匹配，则网格颜色中每个三角形的颜色在每个顶点处的颜色值之间插值；
- 如果颜色数等于非唯一顶点数，则每个三角形的颜色在面上的颜色值之间插值，但可能不会在面之间混合。

## 示例

在下面的示例中，网格根据顶点的标高进行颜色编码。首先，“Mesh.Vertices”用于获取唯一的网格顶点，然后对其进行分析，并使用“'Point.Z”节点获取每个顶点的高程。其次，“Map.RemapRange”用于通过按比例缩放每个值，将值映射到从 0 到 1 的新范围。最后，“Color Range”用于生成与映射值对应的颜色列表。将此颜色列表用作“GeometryColor.ByMeshColors”节点的“colors”输入。结果是一个颜色编码网格，其中每个三角形的颜色在顶点颜色之间插值，从而形成渐变。

## 示例文件

![Example](./Modifiers.GeometryColor.ByMeshColors_img.jpg)
