## 详细

“条形图”会创建一个图表，其中条形位于垂直方向。条形可以组织在多个组下，并使用颜色编码进行标记。可以通过输入一个双精度值来创建单个组，也可以通过在值输入中的每个子列表中输入多个双精度值来创建多个组。要定义类别，请在标签输入中插入一列字符串值。每个值都会创建一个新的颜色编码类别。

要为每个条形指定值(高度)，请在值输入中输入包含双精度值的一列列表。每个列表都会按照与标签输入相同的顺序，来确定条形的数量及其所属的类别。如果您有一列双精度值，则仅会创建一个类别。标签输入中字符串值的数量必须与值输入中子列表的数量相匹配。

要为每个类别指定颜色，请在颜色输入中插入一列颜色。当指定自定义颜色时，颜色的数量必须与标签输入中字符串值的数量相匹配。如果未指定颜色，则将使用随机颜色。

## 示例: 单个组

假定您要表示某个项目在当年的前三个月的平均用户评级。要可视化此情况，您需要一个包含三个字符串值的列表，分别标记为“January”、“February”和“March”。
因此，对于标签输入，我们将在代码块中提供以下列表:

[“January”, “February”, “March”];

也可以使用连接到“List Create”节点的“String”节点来创建列表。

接下来，在值输入中，我们会将每三个月的平均用户评级输入为一列列表:

[[3.5], [5], [4]];

请注意，由于我们有三个标签，因此我们需要三个子列表。

现在，当运行图形时，将创建条形图，其中每个彩色条表示当月的平均客户评级。可以继续使用默认颜色，也可以在颜色输入中插入一列自定义颜色。

## 示例: 多个组

可以通过在值输入的每个子列表中输入更多值，来利用“Bar Chart”节点的分组功能。在本例中，让我们创建一个图表，以“Model A”、“Model B”和“Model C”这三个模型的变体来可视化门数。

为此，我们将首先提供标签:

[“Model A”, “Model B”, “Model C”];

接下来，我们将再次提供值，以确保子列表的数量与标签的数量匹配:

[[17, 9, 13],[12,11,15],[15,8,17]];

现在，当单击“运行”时，“Bar Chart”节点将创建一个包含三组条形图的图表，分别标记为 Index 0、1 和 2。在本例中，将每个索引(即组)视为设计变体。第一组(Index 0)中的值是从输入值的每个列表中的第一项中提取的，因此第一组包含 Model A 的 17、Model B 的 12 和 Model C 的 15。第二组(Index 1)使用每组中的第二个值，依此类推。

___
## 示例文件

![Bar Chart](./CoreNodeModelsWpf.Charts.BarChartNodeModel_img.jpg)

