## Подробности
`GeometryColor.ByMeshColor` возвращает объект GeometryColor — сеть, окрашенную в соответствии с заданным списком цветов. Есть несколько способов использования этого узла.

- Если указан один цвет, то вся сеть окрашивается в один заданный цвет.
- Если количество цветов совпадает с количеством треугольников, каждый треугольник окрашивается в соответствующий цвет из списка.
- Если количество цветов совпадает с количеством уникальных вершин, то цвет каждого треугольника в сети интерполируется между значениями цвета в каждой вершине.
- Если количество цветов равно количеству неуникальных вершин, цвет каждого треугольника интерполируется между значениями цветов по всей грани, но может не смешиваться между гранями.

## Пример

В приведенном ниже примере сеть имеет цветовую маркировку в зависимости от высоты вершин. Сначала с помощью `Mesh.Vertices` извлекаются и анализируются уникальные вершины сети, а затем с помощью узла `Point.Z` вычисляется отметка каждой точки вершины. После этого с помощью `Map.RemapRange` сопоставляются значения с новым диапазоном от 0 до 1 путем пропорционального масштабирования каждого значения. Наконец, с помощью `Color Range` создается список цветов, соответствующих сопоставленным значениям. Этот список цветов используется в качестве входного значения параметра `colors` в узле `GeometryColor.ByMeshColors`. Создается сеть с цветовой кодировкой, в которой цвет каждого треугольника интерполируется между цветами вершин. Таким образом получается градиент.

## Файл примера

![Example](./Modifiers.GeometryColor.ByMeshColors_img.jpg)
