## Подробности
Узел `Curve Mapper` перераспределяет последовательность входных значений в пределах заданного диапазона и использует математические кривые для их сопоставления вдоль заданной кривой. Сопоставление в этом контексте означает перераспределение значений таким образом, что их координаты X повторяют форму кривой вдоль оси Y. Этот метод особенно ценен для проектирования фасадов, параметрических конструкций крыш и других проектных расчетов, где требуются определенные шаблоны или распределения.

Определите лимиты для координат X, установив минимальное и максимальное значения. Эти лимиты задают границы, в пределах которых будет происходить перераспределение точек. Можно указать либо отдельное количество для создания последовательности равномерно распределенных значений, либо существующую серию значений, которые будут распределены вдоль оси X в пределах заданного диапазона и затем сопоставлены с кривой.

Выберите математическую кривую из предложенных вариантов, которые включают линейную кривую, синусоиду, косинусоиду, кривую шума Перлина, кривую Безье, кривую Гаусса, параболу, кривую квадратного корня или кривую степени. Используйте интерактивные управляющие точки, чтобы настроить форму выбранной кривой в соответствии с вашими потребностями.

С помощью кнопки блокировки можно зафиксировать форму кривой, чтобы предотвратить ее дальнейшее изменение. Кроме того, можно восстановить состояние формы по умолчанию с помощью кнопки сброса внутри узла. Если выводится NaN или Null, обратитесь к [этой статье](https://dynamobim.org/introducing-the-curve-mapper-node-in-dynamo/#CurveMapper_Known_Issues), чтобы узнать больше о возможных причинах этого.

Например, чтобы перераспределить 80 точек вдоль синусоиды в диапазоне от 0 до 20, задайте для параметра Min значение 0, для Max — 20, для Values — 80. После выбора синусоиды и корректировки ее формы узел `Curve Mapper` выводит 80 точек с координатами X, которые соответствуют шаблону синусоиды вдоль оси Y.

Чтобы сопоставить неравномерно распределенные значения вдоль кривой Гаусса, задайте минимальный и максимальный диапазоны и укажите последовательность значений. После выбора кривой Гаусса и корректировки ее формы узел `Curve Mapper` перераспределяет последовательность значений по координатам X с использованием заданного диапазона и сопоставляет значения вдоль шаблона кривой. Подробная документация о том, как работает узел и как задавать входные данные, см. в [этой публикации блога](https://dynamobim.org/introducing-the-curve-mapper-node-in-dynamo), посвященной Curve Mapper.




___
## Файл примера

![Example](./GV5KUSHDGL7YVBZAR4HEGY5NIXFIG3XTV6ZQPHC5MWWGEVOSRJ4Q_img.png)
