## Подробности

Функция «Линейчатая диаграмма» создает диаграмму с вертикальными столбцами. Столбцы можно упорядочить в нескольких группах и пометить разными цветами. Можно создать одну группу, введя одно двойное значение, или несколько групп, введя несколько двойных значений для каждого вложенного списка в поле ввода значений. Чтобы определить категории, вставьте список строковых значений в поле меток. На основе каждого значения будет создана новая категория с соответствующим цветом.

Чтобы назначить значение (высоту) каждому столбцу, добавьте в поле ввода значений список списков, где содержатся двойные значения. Каждый вложенный список определяет количество столбцов и категорию, к которой они относятся. Их порядок соответствует порядку ввода меток. Если список двойных значений один, будет создана только одна категория. Количество строковых значений в поле ввода меток должно соответствовать количеству вложенных списков в поле ввода значений.

Категориям можно присвоить цвета, указав список цветов в соответствующем поле. Если пользователь задает свои цвета, их количество должно соответствовать количеству строковых значений в метках. Если не указать цвета, каждой категории будет назначен случайный цвет.

## Пример: одна группа

Допустим, требуется визуализировать средние оценки пользователей для элемента за первые три месяца года. Для этого вам необходим список из трех строковых значений с метками «Январь», «Февраль», «Март».
Для ввода меток в Code Block будет предоставлен следующий список:

["Январь", "Февраль", "Март"];

Для создания списка можно также использовать узлы String, подключенные к узлу List Create.

Далее в поле ввода значений мы введем среднюю оценку пользователей за каждый из трех месяцев в виде списка списков:

[[3.5], [5], [4]];

Поскольку у нас три метки, нам нужно три вложенных списка.

Теперь при запуске графика будет создана линейчатая диаграмма, в которой каждый цветной столбец будет представлять среднюю оценку клиентов за месяц. Можно использовать цвета по умолчанию или добавить список пользовательских цветов в поле ввода цветов.

## Пример: несколько групп

Используйте функционал группирования узлов линейчатой диаграммы, вводя дополнительные значения в каждый вложенный список в поле ввода значений. В этом примере мы создадим диаграмму, на которой будет показано количество дверей в трех вариантах моделей: модель A, модель B и модель C.

Для этого сначала необходимо указать метки:

["Модель A", "Модель B", "Модель C"];

Далее мы введем значения, еще раз убедившись, что количество вложенных списков соответствует количеству меток:

[[17, 9, 13],[12,11,15],[15,8,17]];

Теперь при нажатии кнопки «Выполнить» узел «Линейчатая диаграмма» создаст диаграмму с тремя группами столбцов с индексами 0, 1 и 2 соответственно. В этом примере каждый индекс (то есть группа) является вариантом проекта. Значения в первой группе (индекс 0) извлекаются из первого элемента в каждом списке входных значений, поэтому первая группа содержит 17 для модели A, 12 для модели B и 15 для модели C. Во второй группе (индекс 1) используется второе значение в каждой группе и т. д.

___
## Файл примера

![Bar Chart](./CoreNodeModelsWpf.Charts.BarChartNodeModel_img.jpg)

