## Подробности
`Mesh.VertexIndicesByTri` возвращает выровненный список индексов вершин, соответствующих каждому треугольнику сети. Индексы упорядочиваются по тройкам, а группы индексов можно легко реконструировать с помощью узла `List.Chop` с входным значением `lengths`, равным 3.

В приведенном ниже примере `MeshToolkit.Mesh` с 20 треугольниками преобразуется в `Geometry.Mesh`. Узел `Mesh.VertexIndicesByTri` используется для получения списка индексов, который затем делится на списки из трех индексов с помощью `List.Chop`. Структура списков переворачивается с помощью `List.Transpose` для получения трех списков верхнего уровня из 20 индексов, соответствующих точкам A, B и C в каждом треугольнике сети. Узел `IndexGroup.ByIndices` используется для создания групп индексов по три индекса в каждой. Структурированный список `IndexGroups` и список вершин затем используются в качестве входных данных для `Mesh.ByPointsFaceIndices` с целью получения преобразованной сети.

## Файл примера

![Example](./Autodesk.DesignScript.Geometry.Mesh.VertexIndicesByTri_img.jpg)
