## Подробности
`Mesh.TrainglesAsNineNumbers` определяет координаты X, Y и Z вершин, составляющих каждый треугольник в предоставленной сети, в результате чего на каждый треугольник приходится девять чисел. Этот узел можно использовать для запроса, реконструкции или преобразования исходной сети.

В приведенном ниже примере для импорта сети используются узлы `File Path` и `Mesh.ImportFile`. Для получения координат вершин каждого треугольника используется узел `Mesh.TrianglesAsNineNumbers`. Этот список разделяется на три с помощью узла `List.Chop`, где для входного параметра `lengths` задано значение 3. Затем узел `List.GetItemAtIndex` используется для получения каждой координаты X, Y и Z и перестроения вершин с помощью `Point.ByCoordinates`. Список точек делится на три (3 точки на каждый треугольник) и используется в качестве входных данных для узла `Polygon.ByPoints`.

## Файл примера

![Example](./Autodesk.DesignScript.Geometry.Mesh.TrianglesAsNineNumbers_img.jpg)
