## Подробности
`Mesh.Sphere` создает сеть-сферу по заданным значениям `radius` и `divisions` с центром во входной точке `origin`. Логический входной параметр `icosphere` используется для переключения между типами сферической сети `icosphere` и `UV-Sphere`. Икосферная сеть покрывает сферу с большим количеством правильных треугольников, чем сеть UV, и, как правило, дает лучшие результаты при последующих операциях моделирования. Полюса UV-сети выровнены по оси сферы, а слои треугольников формируются продольно вокруг оси.

В икосфере количество треугольников вокруг оси сферы может быть равно количеству делений и не может превышать это число больше, чем в два раза. Количество делений `UV-sphere` определяет количество слоев треугольников, создаваемых продольно вокруг сферы. Если входной параметр `divisions` равен нулю, узел возвращает UV-сферу с числом делений по умолчанию для любого типа сети (32).

В приведенном ниже примере узел `Mesh.Sphere` используется для создания двух сфер с одинаковым радиусом и количеством делений, но разными методами. Если входной параметр `icosphere` имеет значение `True`, узел `Mesh.Sphere` возвращает `icosphere`. Если входной параметр `icosphere` имеет значение `False`, узел `Mesh.Sphere` возвращает `UV-sphere`.

## Файл примера

![Example](./Autodesk.DesignScript.Geometry.Mesh.Sphere_img.jpg)
