## 상세
`GeometryColor.ByMeshColor`는 지정된 색상 리스트에 따라 색상이 지정된 메쉬인 GeometryColor 객체를 반환합니다. 다음과 같은 몇 가지 방법으로 이 노드를 사용할 수 있습니다.

- 하나의 색상이 제공되는 경우 전체 메쉬가 하나의 지정된 색상으로 색상이 지정됩니다.
- 색상 수가 삼각형 수와 일치하는 경우 각 삼각형은 리스트의 해당 색상으로 지정됩니다.
- 색상 수가 고유한 정점 수와 일치하는 경우 메쉬의 각 삼각형 색상이 각 정점의 색상 값 사이에서 보간됩니다.
- 색상 수가 고유하지 않은 정점 수와 같은 경우 각 삼각형의 색상이 면의 색상 값 간에 보간되지만 면 간에는 혼합되지 않을 수 있습니다.

## 예제

아래 예제에서 메쉬는 정점의 높이에 따라 색상으로 구분됩니다. 먼저 `Mesh.Vertices`는 분석을 위해 고유한 메쉬 정점을 가져오는 데 사용됩니다. 각 정점의 높이는 `Point.Z` 노드를 사용하여 구할 수 있습니다. 다음으로, `Map.RemapRange`는 각 값을 비례적으로 배율 조정하여 0에서 1까지의 새로운 값 범위에 매핑하는 데 사용됩니다. 마지막으로 `Color Range`는 매핑된 값에 해당하는 색상 리스트를 생성하는 데 사용됩니다. 이 색상 리스트를 `GeometryColor.ByMeshColors` 노드의 `colors` 입력으로 사용합니다. 그러면 각 삼각형의 색상이 정점 색상 간에 보간되어 그라데이션이 생긴 색상으로 구분된 메쉬가 생성됩니다.

## 예제 파일

![Example](./Modifiers.GeometryColor.ByMeshColors_img.jpg)
