## 상세
`Curve Mapper` 노드는 정의된 범위 내에서 일련의 입력 값을 재분포한 후 수학 곡선을 활용하여 지정된 곡선을 따라 이 값을 매핑합니다. 이 컨텍스트에서 매핑이란 x 좌표가 y 축을 따라 곡선 모양을 따르는 방식으로 값이 재분포되는 것을 의미합니다. 이 기술은 특히 파사드 디자인, 파라메트릭 지붕 구조 및 특정 패턴이나 분배가 요구되는 기타 설계 계산과 같은 응용 분야에서 유용합니다.

최소값과 최대값을 설정하여 x 좌표에 대한 제한을 정의합니다. 이러한 제한에 따라 점이 재분포될 경계 범위가 설정됩니다. 균등하게 분포된 일련의 값을 생성하기 위해 단일 카운트를 제공하거나 기존의 일련의 값을 제공할 수 있으며, 이는 지정된 범위 내에서 x 방향을 따라 분포된 다음 곡선에 매핑됩니다.

제공된 옵션에서 수학적 곡선(선형, 사인, 코사인, 펄린 노이즈, 베지에, 가우스, 포물선, 제곱근, 거듭제곱 곡선)을 선택합니다. 선택한 곡선의 모양을 조정하기 위해 인터랙티브 제어점을 사용해 곡선의 모양을 원하는 형태로 조정합니다.

잠금 버튼을 사용하여 곡선 모양을 잠글 수 있습니다. 그러면 곡선을 더 이상 수정할 수 없습니다. 또한 노드 내부의 재설정 버튼을 사용하여 모양을 기본 상태로 재설정할 수도 있습니다. NaN 또는 Null이 출력으로 표시되는 경우 해당 출력이 표시되는 이유에 대한 자세한 내용은 [여기](https://dynamobim.org/introducing-the-curve-mapper-node-in-dynamo/#CurveMapper_Known_Issues)에서 확인할 수 있습니다.

예를 들어 0~20의 범위 내에서 사인 곡선을 따라 80개의 점을 재분포하려면 최소값을 0으로, 최대값을 20으로, 값을 80으로 설정합니다.' 사인 곡선을 선택하고 필요에 따라 곡선의 모양을 조정하면, `Curve Mapper` 노드는 y 축을 따라 사인 곡선 패턴을 따르는 x 좌표를 가진 80개의 점을 출력합니다.

가우스 곡선을 따라 균일하지 않게 분포된 값을 매핑하려면 최소 및 최대 범위를 설정하고 일련의 값을 제공합니다. 가우스 곡선을 선택하고 필요에 따라 모양을 조정하면 `Curve Mapper` 노드가 지정된 범위를 사용하여 x 좌표를 따라 일련의 값을 재분포하고 곡선 패턴을 따라 값을 매핑합니다. 노드의 작동 방식과 입력을 설정하는 방법을 자세히 알아보려면 Curve Mapper를 집중적으로 다루는 [이 블로그 게시물](https://dynamobim.org/introducing-the-curve-mapper-node-in-dynamo)을 확인하십시오.




___
## 예제 파일

![Example](./GV5KUSHDGL7YVBZAR4HEGY5NIXFIG3XTV6ZQPHC5MWWGEVOSRJ4Q_img.png)
