## 상세

막대 차트는 세로 방향의 막대가 있는 차트를 생성합니다. 막대는 여러 그룹으로 구성할 수 있고 색상 코드로 레이블을 지정할 수 있습니다. 값 입력에 하나의 double 값을 입력하여 단일 그룹을 작성하거나 하위 리스트별로 여러 개의 double 값을 입력하여 여러 그룹을 생성할 수 있습니다. 범주를 정의하려면 레이블 입력에 문자열 값 리스트를 삽입합니다. 각 값에 의해 색상으로 구분된 새로운 범주가 생성됩니다.

값(높이)을 각 막대에 지정하려면 값 입력에 double 값이 포함된 리스트의 리스트를 입력합니다. 각 하위 리스트에 따라 레이블 입력과 같은 순서로 막대 수와 막대가 속하는 범주가 결정됩니다. 하나의 double 값 리스트가 있는 경우 하나의 범주만 생성됩니다. 레이블 입력의 문자열 값 수는 값 입력의 하위 리스트 수와 일치해야 합니다.

각 범주에 색상을 지정하려면 색상 입력에 색상 리스트를 삽입합니다. 사용자 지정 색상을 지정할 때 색상 수는 레이블 입력의 문자열 값 수와 일치해야 합니다. 색상을 지정하지 않으면 임의의 색상이 사용됩니다.

## 예제: 단일 그룹

올해 첫 3개월 동안의 항목에 대한 평균 사용자 평점을 나타내려고 한다고 가정해 보겠습니다. 이를 시각화하려면 1월, 2월 및 3월로 레이블이 지정된 세 개의 문자열 값 리스트가 필요합니다.
따라서, 레이블 입력으로 다음 리스트를 코드 블록에 입력하겠습니다.

["1월", "2월", "3월"];

리스트 작성 노드에 연결된 문자열 노드를 사용하여 리스트를 작성할 수도 있습니다.

다음으로, 값 입력에 3개월 각각에 대한 평균 사용자 평점을 리스트의 리스트로 입력하겠습니다.

[[3.5], [5], [4]];

세 개의 레이블이 있으므로 세 개의 하위 리스트가 필요합니다.

이제 그래프를 실행되면 막대 차트가 생성되고, 색상이 지정된 각 막대는 해당 월의 평균 고객 평점을 나타냅니다. 기본 색상을 계속 사용하거나 색상 입력에 사용자 지정 색상 리스트를 연결할 수 있습니다.

## 예제: 여러 그룹

값 입력의 각 하위 리스트에 더 많은 값을 입력하여 막대 차트 노드의 그룹화 기능을 활용할 수 있습니다. 이 예에서는 세 가지 모델, 즉 모델 A, 모델 B 및 모델 C의 변형에 대해 문의 수를 시각화하는 차트를 생성해 보겠습니다.

이를 위해 먼저 레이블을 입력하겠습니다.

["모델 A", "모델 B", "모델 C"];

다음으로, 값을 입력하고 다시 한 번 하위 리스트 수가 레이블 수와 일치하는지 확인하겠습니다.

[[17, 9, 13],[12,11,15],[15,8,17]];

이제 실행을 클릭하면 막대 차트 노드에서 각각 색인 0, 1 및 2로 표시된 세 개의 막대 그룹이 있는 차트를 생성합니다. 이 예에서는 각 색인(예: 그룹)을 설계 변형으로 간주합니다. 첫 번째 그룹(색인 0)의 값은 값 입력에 있는 각 리스트의 첫 번째 항목에서 가져옵니다. 따라서 첫 번째 그룹에는 모델 A에 대해 17개, 모델 B에 대해 12개, 모델 C에 대해 15개가 포함됩니다. 두 번째 그룹(색인 1)은 각 그룹의 두 번째 값을 사용하는 식입니다.

___
## 예제 파일

![Bar Chart](./CoreNodeModelsWpf.Charts.BarChartNodeModel_img.jpg)

