## 상세

Define Data 노드는 수신 데이터의 데이터 유형이 유효한지 검사합니다. 이 노드는 로컬 데이터가 원하는 유형인지 확인하는 데 사용할 수 있으며, 그래프가 예상하거나 제공하는 데이터 유형을 선언하는 입력 또는 출력 노드로도 사용할 수 있도록 설계되었습니다. 노드는 '문자열', '점' 또는 '부울'과 같이 일반적으로 사용되는 다양한 Dynamo 데이터 유형을 지원합니다. 지원되는 데이터 유형의 전체 리스트는 노드의 드롭다운 메뉴에서 확인할 수 있습니다. 노드는 단일 값 또는 단순 리스트 형식의 데이터를 지원합니다. 중첩 목록, 사전 및 복제는 지원되지 않습니다.

### 동작

노드는 유형 드롭다운 메뉴 및 리스트 전환(자세한 내용은 아래 참조)의 설정을 기준으로 입력 포트에서 들어오는 데이터의 유효성을 검사합니다. 유효성 검사에 성공하면 노드의 출력이 입력과 동일한 것입니다. 유효성 검사에 실패하면 노드는 경고 상태로 전환되며 null이 출력됩니다.
노드에는 다음과 같은 1개의 입력이 있습니다.

-   "**>**" 입력 - 업스트림 노드에 연결하여 데이터 유형의 유효성을 검사합니다.
    또한 노드는 다음과 같은 3개의 사용자 컨트롤을 제공합니다.
-   **자동 탐지 유형** 전환 - 켜져 있으면 노드는 수신 데이터를 분석하고, 데이터가 지원되는 유형인 경우 수신 데이터의 유형에 따라 유형 및 리스트 컨트롤 값을 설정합니다. 유형 드롭다운 메뉴와 리스트 전환은 비활성화되며 입력 노드에 따라 자동으로 업데이트됩니다.

    자동 탐지 유형이 꺼져 있으면 유형 메뉴와 리스트 전환을 사용하여 데이터 유형을 지정할 수 있습니다. 수신 데이터가 지정한 것과 일치하지 않으면 노드는 경고 상태로 전환되고 null이 출력됩니다.
-   **유형** 드롭다운 메뉴 - 예상 데이터 유형을 설정합니다. 컨트롤이 활성화되어 있는 경우(**자동 탐지 유형** 전환이 꺼져 있는 경우) 유효성을 검사할 데이터 유형을 설정합니다. 컨트롤이 비활성화되어 있는 경우(**자동 탐지 유형** 전환이 켜져 있는 경우) 수신 데이터에 따라 데이터 유형이 자동으로 설정됩니다. 데이터의 유형이 표시된 유형과 정확히 일치하거나 해당 유형이 표시된 유형의 하위 유형인 경우 데이터가 유효합니다(예: 유형 드롭다운이 "곡선"으로 설정된 경우 "직사각형", "선" 등의 객체 유형이 유효함).
-   **리스트** 전환 - 켜져 있으면 노드는 수신 데이터가 유효한 데이터 유형의 항목을 포함하는 단일한 단순 리스트일 것으로 예상합니다(위 참조). 꺼져 있으면 노드는 유효한 데이터 유형의 단일 항목을 예상합니다.

### 입력 노드로 사용

입력으로 설정하면(노드의 상황에 맞는 메뉴에서 "입력임") 노드는 선택적으로 업스트림 노드를 사용하여 입력의 기본값을 설정할 수 있습니다. 그래프를 실행하면 Engine Node와 같이 외부에서 그래프를 실행할 때 사용할 수 있도록 Define Data 노드의 값이 캐시됩니다.

## 예제 파일

아래 예에서 "DefineData" 노드의 첫 번째 그룹의 경우 **자동 탐지 유형** 전환이 꺼져 있습니다. 이 노드는 제공된 Number 입력의 유효성을 올바르게 검사하는 동시에 String 입력은 거부합니다. 두 번째 그룹에는 **자동 탐지 유형**이 켜져 있는 노드가 포함되어 있습니다. 이 노드는 입력(이 경우 정수의 리스트)과 일치하도록 유형 드롭다운과 리스트 전환을 자동으로 조정합니다.

![Define_Data](./CoreNodeModels.DefineData_img.png)
