## 詳細
`Curve Mapper` ノードは、定義された範囲内で一連の入力値を再分布し、数学的曲線を活用して、指定した曲線に沿って値をマッピングします。ここでのマッピングとは、X 座標が曲線の Y 軸方向の形状に従うように再分布することを意味します。この手法は、ファサード設計、パラメトリック屋根構造、および特定のパターンや分布が必要となるその他の設計計算などの用途で特に役立ちます。

X 座標の最小値と最大値を設定して、その範囲を定義します。この範囲は、点が再分布される境界となります。均一に分布する値を生成するための単一の数値、または既存の一連の値を指定できます。いずれの場合も、特定の範囲内で X 軸方向に沿って再分布され、曲線にマッピングされます。

表示されたオプションから、線形曲線、正弦曲線、余弦曲線、パーリン ノイズ曲線、ベジェ曲線、ガウス曲線、放物曲線、平方根曲線、指数曲線などの数学的曲線を選択します。インタラクティブな制御点を使用して、選択した曲線の形状を特定のニーズに合わせて調整します。

ロック ボタンを使用して曲線の形状をロックし、それ以降の曲線の変更を防ぐことができます。また、ノード内のリセット ボタンを使用して、形状を既定の状態にリセットすることもできます。NaN または Null が出力された場合は、表示された理由の詳細を[こちら](https://dynamobim.org/introducing-the-curve-mapper-node-in-dynamo/#CurveMapper_Known_Issues)で確認できます。

たとえば、0 ～ 20 の範囲で正弦曲線に沿って 80 個の点を再分布するには、最小を 0、最大を 20、値を 80 に設定します。正弦曲線を選択し、必要に応じて形状を調整すると、`Curve Mapper` ノードは、Y 軸に沿った正弦曲線パターンに従って配置された X 座標を持つ、80 個の点を出力します。

不均一に分布した値をガウス曲線に沿ってマッピングするには、最小範囲と最大範囲を設定し、一連の値を指定します。ガウス曲線を選択し、必要に応じて形状を調整すると、`Curve Mapper` ノードは、指定された範囲内で X 座標に沿って一連の値を再分布し、曲線パターンに沿って値をマッピングします。ノードの仕組みと入力設定の詳細なドキュメントについては、Curve Mapper に焦点を当てた[こちらのブログの投稿](https://dynamobim.org/introducing-the-curve-mapper-node-in-dynamo)で確認してください。




___
## サンプル ファイル

![Example](./GV5KUSHDGL7YVBZAR4HEGY5NIXFIG3XTV6ZQPHC5MWWGEVOSRJ4Q_img.png)
