## 詳細
`List.GroupBySimilarity` は、インデックスの隣接関係と値の類似性に基づいてリストの要素をクラスタ化します。クラスタ化する要素のリストには数値(整数と浮動小数点数)または文字列を含めることができますが、両方を組み合わせることはできません。

要素の類似性を判定するには、`tolerance` 入力を使用します。数値のリストの場合、`tolerance` の値は、2 つの数値が類似していると見なされる最大許容差です。

文字列リストの場合、'tolerance' は 2 つの文字列間で異なる文字数の許容される最大数であり、レーベンシュタイン距離を比較に使用します。文字列の最大許容差は 10 に制限されます。

`considerAdjacency` ブール値入力は、要素をクラスタ化するときに隣接関係を考慮するかどうかを示します。True の場合は、類似した隣接する要素のみがクラスタ化されます。False の場合は、隣接関係に関係なく、類似性のみを使用してクラスタが形成されます。

このノードは、隣接関係と類似性に基づいてクラスタ化された値のリストのリストと、元のリスト内のクラスタ化された要素のインデックスのリストのリストを出力します。

次の例では、`List.GroupBySimilarity` は、類似性のみによって文字列のリストをクラスタ化する方法と、隣接関係と類似性によって数値のリストをクラスタ化する方法の、2 つの方法で使用されています。
___
## サンプル ファイル

![List.GroupBySimilarity](./DSCore.List.GroupBySimilarity_img.jpg)
