## 詳細

Define Data ノードは、入力データのデータ タイプを検証します。ローカル データが目的の型であることを確認するために使用でき、グラフが予測または提供するデータのタイプを宣言する入力ノードまたは出力ノードとして使用するために設計されています。このノードは、文字列、点群、ブール値など一般的に使用される一連の Dynamo データ タイプをサポートします。サポートされるすべてのデータ タイプの一覧はノードのドロップダウン メニューで確認できます。このノードは、単一の値またはフラット リストの形式のデータをサポートします。ネストされたリスト、ディクショナリ、複製データはサポートされていません。

### 動作

このノードは、Type ドロップダウン メニューの設定および List 切り替えの設定に基づいて、入力ポートからの入力データを検証します(詳細は下記を参照)。検証が成功した場合、ノードの出力は入力と同じになります。検証が成功しなかった場合、ノードは null 出力で警告状態になります。
ノードには 1 つの入力があります。

-   「**>**」入力: 上流のノードに接続し、そのデータのタイプを検証します。
    また、このノードは 3 つのユーザー コントロールを提供します。
-   **Auto-detect type** 切り替え: オンに切り替えると、このノードは入力データを分析し、そのデータがサポートされているタイプである場合は、入力データのタイプに基づき Type コントロールと List コントロールの値を設定します。Type ドロップダウン メニューおよび List 切り替えは無効化され、入力ノードに基づき自動的に更新します。

    Auto-detect type をオフを切り替えると、Type メニューと List 切り替えを使ってデータ タイプを指定できます。入力データが指定したタイプと一致しない場合は、ノードは null を出力し警告状態になります。
-   **Type** ドロップダウン メニュー: 想定されるデータ タイプを設定します。コントロールが有効な場合(**Auto-detect type** 切り替えがオフ)は、検証するデータ タイプを設定します。コントロールが無効な場合(**Auto-detect type** 切り替えがオン)は、データ タイプは入力データに基づき自動的に設定されます。データは、そのタイプが表示されたタイプと完全に一致する場合や表示されるタイプの子である場合は有効です(たとえば、Type ドロップダウンで Curve に設定されている場合は、「Rectangle」「Line」などのタイプのオブジェクトは有効です)。
-   **List** 切り替え: オンの場合、ノードは有効なデータ タイプの項目を含む単一のフラット リストである入力データが想定されます(上記参照)。オフの場合、ノードは有効なデータ タイプの単一の項目が想定されます。

### 入力ノードとして使用

入力として設定する場合(ノードのコンテキスト メニューの「入力」)、ノードは必要に応じて上流ノードを使用して入力の既定値を設定できます。グラフを実行すると、Engine ノードなどで、グラフを外部的に実行する場合に使用する Define Data ノードの値がキャッシュされます。

## サンプル ファイル

次の例では、「DefineData」ノードの 1 番目のグループは **Auto-detect type** 切り替えがオフになっています。ノードは、提供された Number 入力を正しく検証する一方で、String 入力を拒否します。2 番目のグループには **Auto-detect type** をオンに切り替えたノードが含まれています。この場合、ノードは Type ドロップダウンと List 切り替えを自動的に調整し、入力(この場合は整数のリスト)に一致させます。

![Define_Data](./CoreNodeModels.DefineData_img.png)
