## 詳細
`Mesh.Sphere` は、入力された `origin` 点を中心に、指定された `radius` と多数の `divisions` を持つ球体のメッシュを作成します。`icosphere` のブール値入力は、`icosphere` タイプと `UV-Sphere` タイプの球体メッシュを切り替えるために使用されます。イコスフィア メッシュは、UV メッシュよりも規則的な三角形で球体を覆うため、後続のモデリング操作でより良い結果を得られる傾向があります。UV メッシュでは、球体の極が軸に沿って配置され、三角形の層が軸を中心に縦方向に生成されます。

イコスフィアの場合、球体の軸を中心とする三角形の数は、指定された分割数と同じか、最大でその数の 2 倍になる可能性があります。`UV-sphere`の分割数は、球体の周囲に縦方向で生成される三角形の層の数を決定します。`divisions` 入力がゼロに設定されている場合、このノードはどちらのメッシュ タイプに対しても、既定の 32 分割で UV 球体を返します。

次の例では、`Mesh.Sphere` ノードを使用して、半径と分割数が同じ 2 つの球体を異なるメソッドで作成します。`icosphere` 入力が `True` に設定されている場合、`Mesh.Sphere` は `icosphere` を返します。一方、`icosphere` 入力が `False` に設定されている場合、`Mesh.Sphere` は `UV-sphere` を返します。

## サンプル ファイル

![Example](./Autodesk.DesignScript.Geometry.Mesh.Sphere_img.jpg)
