## 詳細
`Mesh.GenerateSupport` ノードは、3D 印刷の準備用に入力されたメッシュ ジオメトリに対し、サポートを追加するために使用されます。オーバーハングがあるジオメトリを正常に印刷して、適切な層の接着性を確保し、印刷プロセス中にマテリアルが垂れ下がらないようにするには、サポートが必要です。`Mesh.GenerateSupport` は、オーバーハングを検出してツリータイプのサポートを自動的に生成します。このサポートはマテリアルの消費量および印刷面との接触が少なく、取り外しが簡単なものです。オーバーハングが検出されない場合、`Mesh.GenerateSupport` ノードは同じメッシュを回転させて印刷の最適な向きに調整し、XY 平面で移動させます。サポートの構成は、次の入力によってコントロールされます。
- baseHeight は、サポートの最下部(底部)の厚さを定義する
- baseDiameter は、サポートの底部のサイズをコントロールする
- postDiameter 入力は、各サポートの中央のサイズをコントロールする
- tipHeight と tipDiameter は、印刷面に接触するサポートの先端部のサイズをコントロールする
次の例では、`Mesh.GenerateSupport` ノードを使用して、文字「T」の形をしたメッシュにサポートを追加します。

## サンプル ファイル

![Example](./Autodesk.DesignScript.Geometry.Mesh.GenerateSupport_img.jpg)
