## 詳細
このノードは、指定されたメッシュ内のエッジ数をカウントします。メッシュが三角形で構成されている場合(`MeshToolkit` のすべてのメッシュがこれに当てはまる)、`Mesh.EdgeCount` ノードは一意のエッジのみを返します。そのため、エッジ数はメッシュ内における三角形の数の 3 倍にならないと予想されます。この仮定を使用して、メッシュに未連結の面が含まれていないことを検証できます(インポートされたメッシュで発生する可能性があります)。

次の例では、`Mesh.Cone` と `Number.Slider` を使用して円錐を作成し、それを入力として用いてエッジをカウントしています。`Mesh.Edges` と `Mesh.Triangles` を使用すると、メッシュの構造と通芯をプレビューできます。複雑で重いメッシュの場合は、`Mesh.Edges` がより優れたパフォーマンスを発揮します。

## サンプル ファイル

![Example](./Autodesk.DesignScript.Geometry.Mesh.EdgeCount_img.jpg)
